/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.indexer.storage;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.configuration.Settings;
import org.dataone.hashstore.HashStore;
import org.dataone.hashstore.HashStoreFactory;
import org.dataone.hashstore.exceptions.HashStoreFactoryException;

public class Storage {
    private static Log log = LogFactory.getLog(Storage.class);
    private static Storage instance;
    private static HashStore hashStore;

    private Storage() throws HashStoreFactoryException, IOException {
        String className = Settings.getConfiguration().getString("storage.className");
        String rootPath = Settings.getConfiguration().getString("storage.hashstore.rootDirectory");
        if (rootPath == null) {
            throw new HashStoreFactoryException("HashStorage.constructor - The HashStore root path  is null or blank from the property of storage.hashstore.rootDirectory");
        }
        String directoryDepth = Settings.getConfiguration().getString("storage.hashstore.directory.depth", "3");
        String directoryNameWidth = Settings.getConfiguration().getString("storage.hashstore.directory.width", "2");
        String fileNameAlgorithm = Settings.getConfiguration().getString("storage.hashstore.fileNameAlgorithm", "SHA-256");
        String defaultNamespace = Settings.getConfiguration().getString("storage.hashstore.defaultNamespace", "https://ns.dataone.org/service/types/v2.0#SystemMetadata");
        Properties storeProperties = new Properties();
        storeProperties.setProperty("storePath", rootPath);
        storeProperties.setProperty("storeDepth", directoryDepth);
        storeProperties.setProperty("storeWidth", directoryNameWidth);
        storeProperties.setProperty("storeAlgorithm", fileNameAlgorithm);
        storeProperties.setProperty("storeMetadataNamespace", defaultNamespace);
        hashStore = HashStoreFactory.getHashStore((String)className, (Properties)storeProperties);
    }

    public static Storage getInstance() {
        return instance;
    }

    public InputStream retrieveObject(String pid) throws IllegalArgumentException, FileNotFoundException, IOException, NoSuchAlgorithmException {
        return hashStore.retrieveObject(pid);
    }

    public InputStream retrieveSystemMetadata(String pid) throws IllegalArgumentException, FileNotFoundException, IOException, NoSuchAlgorithmException {
        return hashStore.retrieveMetadata(pid);
    }

    public void storeObject(InputStream object, String pid) throws NoSuchAlgorithmException, IOException, RuntimeException, InterruptedException {
        hashStore.storeObject(object, pid, null, null, null, -1L);
    }

    public void storeMetadata(InputStream metadata, String pid) throws IOException, IllegalArgumentException, FileNotFoundException, InterruptedException, NoSuchAlgorithmException {
        hashStore.storeMetadata(metadata, pid);
    }

    static {
        try {
            instance = new Storage();
        }
        catch (IOException e) {
            log.error((Object)("Dataone-indexer cannot initialize the Storage class since " + e.getMessage()), (Throwable)e);
            System.exit(1);
        }
    }
}

