/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.indexer.queue;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.LongString;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.types.v1.Identifier;

public class IndexQueueMessageParser {
    private static final String HEADER_ID = "id";
    private static final String HEADER_INDEX_TYPE = "index_type";
    private static final String HEADER_DOCID = "doc_id";
    private Identifier identifier = null;
    private String indexType = null;
    private int priority = 1;
    private String docId = null;
    private static Log logger = LogFactory.getLog(IndexQueueMessageParser.class);

    public void parse(AMQP.BasicProperties properties, byte[] body) throws InvalidRequest {
        if (properties == null) {
            throw new InvalidRequest("0000", "The properties, which contains the index task info, cannot be null in the index queue message.");
        }
        Map headers = properties.getHeaders();
        if (headers == null) {
            throw new InvalidRequest("0000", "The header of the properties, which contains the index task info, cannot be null in the index queue message.");
        }
        Object pidObj = headers.get(HEADER_ID);
        if (pidObj == null) {
            throw new InvalidRequest("0000", "The identifier cannot be null in the index queue message.");
        }
        String pid = ((LongString)pidObj).toString();
        if (pid == null || pid.isBlank()) {
            throw new InvalidRequest("0000", "The identifier cannot be null or blank in the index queue message.");
        }
        logger.debug((Object)("IndexQueueMessageParser.parse - the identifier in the message is " + pid));
        this.identifier = new Identifier();
        this.identifier.setValue(pid);
        Object typeObj = headers.get(HEADER_INDEX_TYPE);
        if (typeObj == null) {
            throw new InvalidRequest("0000", "The index type cannot be null in the index queue message for " + pid);
        }
        this.indexType = ((LongString)typeObj).toString();
        if (this.indexType == null || this.indexType.isBlank()) {
            throw new InvalidRequest("0000", "The index type cannot be null or blank in the index queue message for " + pid);
        }
        logger.debug((Object)("The index type in the message is " + this.indexType + " for " + pid));
        Object docIdObject = headers.get(HEADER_DOCID);
        if (docIdObject != null) {
            this.docId = ((LongString)docIdObject).toString();
        }
        logger.debug((Object)("The docId of the object which will be indexed in the message is " + this.docId + " for " + pid));
        try {
            this.priority = properties.getPriority();
        }
        catch (NullPointerException e) {
            logger.info((Object)"IndexQueueMessageParser.parse - the priority is not set in the message and we will set it to 1.");
            this.priority = 1;
        }
        logger.debug((Object)("IndexQueueMessageParser.parse - the priority in the message is " + this.priority + " for " + pid));
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getDocId() {
        return this.docId;
    }
}

