/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser.utility;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.indexer.parser.TemporalPeriodSolrField;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.w3c.dom.Document;

public class TemporalPeriodParsingUtility {
    private static Log log = LogFactory.getLog(TemporalPeriodSolrField.class);
    public static final String START_FIELD = "start";
    public static final String END_FIELD = "end";
    public static final String SCHEME_FIELD = "scheme";
    public static final String W3C_DTF_SCHEME = "W3C-DTF";
    private static final Map<String, DateTimeFormatter> FORMATTERS = new HashMap<String, DateTimeFormatter>();

    public String extractTextValue(Document doc, XPathExpression xPathExpression) {
        String textValue = null;
        try {
            textValue = (String)xPathExpression.evaluate(doc, XPathConstants.STRING);
            if (textValue != null) {
                textValue = textValue.trim();
            }
        }
        catch (XPathExpressionException e) {
            throw new AssertionError("Unable to get temoral element string value.", e);
        }
        return textValue;
    }

    protected String getFieldValue(String text, String fieldName) {
        Pattern matchPattern = Pattern.compile(".*" + fieldName + "=(.*?);.*");
        Matcher matcher = matchPattern.matcher(text);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public String getScheme(String text) {
        return this.getFieldValue(text, SCHEME_FIELD);
    }

    public String getFormattedStartDate(String text, String scheme) {
        String startDateStr = this.getFieldValue(text, START_FIELD);
        return this.formatDate(startDateStr, scheme);
    }

    public String getFormattedEndDate(String text, String scheme) {
        String endDateStr = this.getFieldValue(text, END_FIELD);
        return this.formatDate(endDateStr, scheme);
    }

    public String formatDate(String dateString, String scheme) {
        DateTime date = this.parseDateTime(scheme, dateString);
        if (date == null) {
            log.error((Object)("Date string could not be parsed: " + dateString));
            return null;
        }
        DateTimeFormatter iso8601Formatter = ISODateTimeFormat.dateTime();
        String dateIso8601 = iso8601Formatter.print((ReadableInstant)date.toDateTime(DateTimeZone.UTC));
        return dateIso8601;
    }

    private DateTime parseDateTime(String scheme, String dateString) {
        if (StringUtils.isEmpty((CharSequence)scheme)) {
            log.info((Object)"No scheme provided, defaulting to W3C-DTF");
            scheme = W3C_DTF_SCHEME;
        }
        DateTimeFormatter formatter = FORMATTERS.get(scheme);
        DateTime dateTime = null;
        try {
            dateTime = formatter.parseDateTime(dateString);
        }
        catch (Exception e) {
            log.error((Object)"");
        }
        return dateTime;
    }

    static {
        FORMATTERS.put(W3C_DTF_SCHEME, ISODateTimeFormat.dateTimeParser());
    }
}

