/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser.utility;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.indexer.solrhttp.DummySolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementField;

public class RelationshipMergeUtility {
    private static Log log = LogFactory.getLog(RelationshipMergeUtility.class);
    private List<String> relationshipFieldsToMerge = null;

    public void merge(SolrDoc from, SolrDoc to) {
        if (to == null) {
            throw new IllegalArgumentException("The solr doc receiving relationship fields should not be null");
        }
        if (from != null && from.getFieldList() != null) {
            for (SolrElementField field : from.getFieldList()) {
                if (field.getName() != null && this.relationshipFieldsToMerge.contains(field.getName()) && field.getValue() != null && !field.getValue().isBlank() && !to.hasFieldWithValue(field.getName(), field.getValue())) {
                    log.debug((Object)("Merge the relationship field " + field.getName() + " with value " + field.getValue() + " to the destination."));
                    to.addField(new SolrElementField(field.getName(), field.getValue()));
                    continue;
                }
                if (field.getName() == null || !field.getName().equals("_version_")) continue;
                log.debug((Object)("Merge the relationship field " + field.getName() + " with value " + field.getValue() + " to the destination."));
                to.removeAllFields(field.getName());
                to.addField(field);
            }
            to.setMerged(true);
        }
    }

    public SolrDoc mergeRelationships(DummySolrDoc dummy, SolrDoc realDoc) {
        SolrDoc newDoc = new SolrDoc();
        if (realDoc == null) {
            if (dummy != null) {
                newDoc.setFieldList(dummy.getFieldList());
            }
        } else {
            List<String> ids = realDoc.getAllFieldValues("id");
            if (ids.size() != 1) {
                throw new IllegalArgumentException("RelationshipMergeUtilityThe.mergeRelationships - real solr document should have only one id.");
            }
            String id = ids.get(0);
            if (id == null || id.isBlank()) {
                throw new IllegalArgumentException("RelationshipMergeUtilityThe.mergeRelationships - the id of the real solr document should not be null or blank.");
            }
            if (dummy == null) {
                newDoc.setFieldList(realDoc.getFieldList());
            } else {
                List<String> dummyIds = dummy.getAllFieldValues("id");
                if (dummyIds.size() != 1) {
                    throw new IllegalArgumentException("RelationshipMergeUtilityThe.mergeRelationships - the dummy solr document should have only one id.");
                }
                if (!id.equals(dummyIds.get(0))) {
                    throw new IllegalArgumentException("RelationshipMergeUtilityThe.mergeRelationships - dummy solr document should have the same id as the one in the real doc.");
                }
                newDoc.setFieldList(realDoc.getFieldList());
                for (SolrElementField field : dummy.getFieldList()) {
                    if (!this.relationshipFieldsToMerge.contains(field.getName()) || newDoc.hasFieldWithValue(field.getName(), field.getValue())) continue;
                    log.debug((Object)("Merge " + field.getName() + " with value " + field.getValue()));
                    newDoc.addField(field);
                }
            }
        }
        return newDoc;
    }

    public List<String> getRelationshipFieldsToMerge() {
        return this.relationshipFieldsToMerge;
    }

    public void setRelationshipFieldsToMerge(List<String> relationshipFieldsToMerge) {
        this.relationshipFieldsToMerge = relationshipFieldsToMerge;
    }
}

