/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServerException;
import org.dataone.cn.indexer.parser.IDocumentSubprocessor;
import org.dataone.cn.indexer.parser.SubprocessorUtility;
import org.dataone.cn.indexer.resourcemap.ResourceMap;
import org.dataone.cn.indexer.resourcemap.ResourceMapFactory;
import org.dataone.cn.indexer.solrhttp.DummySolrDoc;
import org.dataone.cn.indexer.solrhttp.HTTPService;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.types.v1.Identifier;
import org.dspace.foresite.OREParserException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ResourceMapSubprocessor
implements IDocumentSubprocessor {
    private static Log logger = LogFactory.getLog((String)ResourceMapSubprocessor.class.getName());
    private HTTPService httpService = null;
    private String solrQueryUri = Settings.getConfiguration().getString("solr.query.uri");
    private SubprocessorUtility processorUtility;
    private List<String> matchDocuments = null;
    private List<String> fieldsToMerge = new ArrayList<String>();

    @Override
    public SolrDoc mergeWithIndexedDocument(SolrDoc indexDocument) throws IOException, EncoderException, XPathExpressionException {
        return this.processorUtility.mergeWithIndexedDocument(indexDocument, this.fieldsToMerge);
    }

    @Override
    public Map<String, SolrDoc> processDocument(String identifier, Map<String, SolrDoc> docs, InputStream is) throws IOException, EncoderException, SAXException, XPathExpressionException, ParserConfigurationException, SolrServerException, NotImplemented, NotFound, UnsupportedType, OREParserException, ServiceFailure, InterruptedException {
        Identifier id = new Identifier();
        id.setValue(identifier);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document resourceMap = builder.parse(is);
        List<SolrDoc> processedDocs = this.processResourceMap(identifier, resourceMap, docs);
        HashMap<String, SolrDoc> processedDocsMap = new HashMap<String, SolrDoc>();
        for (SolrDoc processedDoc : processedDocs) {
            if (processedDoc == null) continue;
            processedDocsMap.put(processedDoc.getIdentifier(), processedDoc);
        }
        return processedDocsMap;
    }

    private List<SolrDoc> processResourceMap(String identifier, Document resourceMapDOMDoc, Map<String, SolrDoc> docs) throws OREParserException {
        ResourceMap resourceMap = ResourceMapFactory.buildResourceMap(resourceMapDOMDoc);
        List<String> documentIds = resourceMap.getAllDocumentIDs();
        List<SolrDoc> updateDocuments = this.getSolrDocs(identifier, documentIds, docs);
        List<SolrDoc> mergedDocuments = resourceMap.mergeIndexedDocuments(updateDocuments);
        mergedDocuments.add(docs.get(identifier));
        return mergedDocuments;
    }

    private List<SolrDoc> getSolrDocs(String resourceMapId, List<String> ids, Map<String, SolrDoc> docs) {
        ArrayList<SolrDoc> list = new ArrayList<SolrDoc>();
        if (ids != null) {
            for (String id : ids) {
                SolrDoc doc = docs.get(id);
                if (doc != null) {
                    list.add(doc);
                    continue;
                }
                if (id.equals(resourceMapId)) continue;
                doc = new DummySolrDoc(id, docs.get(resourceMapId));
                list.add(doc);
            }
        }
        return list;
    }

    protected static void copyFieldAllValue(String fieldName, SolrDoc source, SolrDoc dest) {
        if (fieldName != null && !fieldName.isBlank()) {
            List<String> values = source.getAllFieldValues(fieldName);
            logger.debug((Object)("The list of all values of the " + fieldName + " field in the source solr doc is " + values));
            if (values != null && !values.isEmpty()) {
                for (String value : values) {
                    dest.addField(new SolrElementField(fieldName, value));
                }
            }
        }
    }

    public List<String> getMatchDocuments() {
        return this.matchDocuments;
    }

    public void setMatchDocuments(List<String> matchDocuments) {
        this.matchDocuments = matchDocuments;
    }

    @Override
    public boolean canProcess(String formatId) {
        return this.matchDocuments.contains(formatId);
    }

    public List<String> getFieldsToMerge() {
        return this.fieldsToMerge;
    }

    public void setFieldsToMerge(List<String> fieldsToMerge) {
        this.fieldsToMerge = fieldsToMerge;
    }

    public void setHttpService(HTTPService service) {
        this.httpService = service;
    }

    public HTTPService getHttpService() {
        return this.httpService;
    }

    public SubprocessorUtility getProcessorUtility() {
        return this.processorUtility;
    }

    public void setProcessorUtility(SubprocessorUtility processorUtility) {
        this.processorUtility = processorUtility;
    }
}

