/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.object.hashstore;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.indexer.object.ObjectManager;
import org.dataone.exceptions.MarshallingException;
import org.dataone.indexer.storage.Storage;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.util.TypeMarshaller;

public class HashStoreObjManager
extends ObjectManager {
    private static Storage storage = null;
    private static Log logger = LogFactory.getLog(ObjectManager.class);

    @Override
    public InputStream getSystemMetadataStream(String id) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound, NoSuchAlgorithmException, IOException, MarshallingException {
        InputStream sysmetaInputStream;
        block3: {
            long start = System.currentTimeMillis();
            sysmetaInputStream = null;
            try {
                sysmetaInputStream = storage.retrieveSystemMetadata(id);
                long end = System.currentTimeMillis();
                logger.info((Object)("Finish getting the system metadata via the file system for the pid " + id + " and it took " + (end - start) + "milliseconds"));
            }
            catch (FileNotFoundException exception) {
                if (d1Node == null) break block3;
                SystemMetadata sysmeta = HashStoreObjManager.getSystemMetadataByAPI(id);
                logger.debug((Object)("Finish getting the system metadata via the DataONE API call for the pid " + id));
                if (sysmeta != null) {
                    ByteArrayOutputStream systemMetadataOutputStream = new ByteArrayOutputStream();
                    TypeMarshaller.marshalTypeToOutputStream((Object)sysmeta, (OutputStream)systemMetadataOutputStream);
                    sysmetaInputStream = new ByteArrayInputStream(systemMetadataOutputStream.toByteArray());
                }
                long end = System.currentTimeMillis();
                logger.info((Object)("Finish getting the system metadata via DataONE API for the pid " + id + " and it took " + (end - start) + "milliseconds"));
            }
        }
        return sysmetaInputStream;
    }

    @Override
    public org.dataone.service.types.v1.SystemMetadata getSystemMetadata(String id) throws InvalidToken, NotAuthorized, NoSuchAlgorithmException, NotImplemented, ServiceFailure, NotFound, InstantiationException, IllegalAccessException, IOException, MarshallingException {
        SystemMetadata sysmeta;
        block15: {
            sysmeta = null;
            try (InputStream input = this.getSystemMetadataStream(id);){
                if (input == null) break block15;
                try {
                    SystemMetadata sysmeta2;
                    sysmeta = sysmeta2 = (SystemMetadata)TypeMarshaller.unmarshalTypeFromStream(SystemMetadata.class, (InputStream)input);
                }
                catch (Exception e) {
                    try (InputStream input2 = this.getSystemMetadataStream(id);){
                        if (input2 != null) {
                            sysmeta = (org.dataone.service.types.v1.SystemMetadata)TypeMarshaller.unmarshalTypeFromStream(org.dataone.service.types.v1.SystemMetadata.class, (InputStream)input2);
                        }
                    }
                }
            }
        }
        return sysmeta;
    }

    @Override
    public InputStream getObject(String pid) throws IllegalArgumentException, NoSuchAlgorithmException, IOException {
        return storage.retrieveObject(pid);
    }

    static {
        try {
            HashStoreObjManager.refreshD1Node();
        }
        catch (ServiceFailure e) {
            logger.warn((Object)("Metacat cannot initialize the d1Node since " + e.getMessage()));
        }
        storage = Storage.getInstance();
    }
}

