/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.convert;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.dataone.cn.indexer.XmlDocumentUtility;
import org.dataone.cn.indexer.solrhttp.HTTPService;
import org.dataone.configuration.Settings;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class MemberNodeServiceRegistrationTypeDocumentService {
    private static Log log = LogFactory.getLog((String)MemberNodeServiceRegistrationTypeDocumentService.class.getName());
    private static final String SERVICE_DOC_LOCATION_URL = Settings.getConfiguration().getString("dataone.mn.registration.serviceType.url");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getMemberNodeServiceRegistrationTypeDocument() {
        Document doc = null;
        InputStream stream = this.fetchServiceTypeDoc();
        if (stream != null) {
            try {
                doc = XmlDocumentUtility.generateXmlDocument(stream);
            }
            catch (SAXException e) {
                log.error((Object)"Unable to create w3c Document from input stream", (Throwable)e);
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        return doc;
    }

    private InputStream fetchServiceTypeDoc() {
        InputStream stream = null;
        HttpClient httpClient = HTTPService.getHttpClient();
        HttpGet get = new HttpGet(SERVICE_DOC_LOCATION_URL);
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)get);
            HttpEntity entity = response.getEntity();
            stream = entity.getContent();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
            log.error((Object)("Unable to fetch service type doc from: " + SERVICE_DOC_LOCATION_URL), (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error((Object)("Unable to fetch service type doc from: " + SERVICE_DOC_LOCATION_URL), (Throwable)e);
        }
        return stream;
    }

    protected String getServiceTypeDocUrl() {
        return SERVICE_DOC_LOCATION_URL;
    }
}

