/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.annotation;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.indexer.annotation.SparqlField;
import org.dataone.cn.indexer.annotation.TripleStoreService;
import org.dataone.cn.indexer.parser.IDocumentSubprocessor;
import org.dataone.cn.indexer.parser.ISolrDataField;
import org.dataone.cn.indexer.parser.SubprocessorUtility;
import org.dataone.cn.indexer.solrhttp.DummySolrDoc;
import org.dataone.cn.indexer.solrhttp.HTTPService;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.dataone.configuration.Settings;
import org.dataone.indexer.performance.PerformanceLogger;

public class RdfXmlSubprocessor
implements IDocumentSubprocessor {
    private static final String RESOLVE_URL = "https://cn.dataone.org/cn/v1/resolve/";
    private static Log log = LogFactory.getLog(RdfXmlSubprocessor.class);
    private static PerformanceLogger perfLog = PerformanceLogger.getInstance();
    private List<String> matchDocuments = null;
    private List<ISolrDataField> fieldList = new ArrayList<ISolrDataField>();
    private List<String> fieldsToMerge = new ArrayList<String>();
    private HTTPService httpService = null;
    private String solrQueryUri = Settings.getConfiguration().getString("solr.query.uri");
    private SubprocessorUtility processorUtility;

    @Override
    public boolean canProcess(String formatId) {
        return this.matchDocuments.contains(formatId);
    }

    public List<String> getMatchDocuments() {
        return this.matchDocuments;
    }

    public void setMatchDocuments(List<String> matchDocuments) {
        this.matchDocuments = matchDocuments;
    }

    public List<ISolrDataField> getFieldList() {
        return this.fieldList;
    }

    public void setFieldList(List<ISolrDataField> fieldList) {
        this.fieldList = fieldList;
    }

    @Override
    public Map<String, SolrDoc> processDocument(String identifier, Map<String, SolrDoc> docs, InputStream is) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)"INCOMING DOCS to processDocument(): ");
            this.serializeDocuments(docs);
        }
        SolrDoc resourceMapDoc = docs.get(identifier);
        this.process(resourceMapDoc, is, docs);
        if (log.isTraceEnabled()) {
            log.trace((Object)"OUTGOING DOCS from processDocument(): ");
            this.serializeDocuments(docs);
        }
        return docs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeDocuments(Map<String, SolrDoc> docs) {
        StringBuilder documents = new StringBuilder();
        documents.append("<docs>");
        for (SolrDoc doc : docs.values()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                doc.serialize(baos, "UTF-8");
            }
            catch (IOException e) {
                log.trace((Object)("Couldn't serialize documents: " + e.getMessage()));
            }
            try {
                documents.append(baos.toString());
            }
            finally {
                IOUtils.closeQuietly((OutputStream)baos);
            }
        }
        documents.append("</docs>");
        log.trace((Object)documents.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(SolrDoc resourceMapDocument, InputStream is, Map<String, SolrDoc> docs) throws Exception {
        long start = System.currentTimeMillis();
        Dataset dataset = TripleStoreService.getInstance().getDataset();
        try {
            perfLog.log("RdfXmlSubprocess.process gets a dataset from triple store service ", System.currentTimeMillis() - start);
            String resourceMapDocId = resourceMapDocument.getIdentifier();
            Object name = resourceMapDocId;
            String scheme = null;
            try {
                URI nameURI = new URI(resourceMapDocId);
                scheme = nameURI.getScheme();
            }
            catch (URISyntaxException use) {
                name = RESOLVE_URL + resourceMapDocId;
            }
            if (scheme == null || scheme.isEmpty()) {
                name = RESOLVE_URL + resourceMapDocId;
            }
            long startOntModel = System.currentTimeMillis();
            boolean loaded = dataset.containsNamedModel((String)name);
            if (!loaded) {
                OntModel ontModel = ModelFactory.createOntologyModel();
                ontModel.read(is, (String)name);
                dataset.addNamedModel((String)name, (Model)ontModel);
            }
            perfLog.log("RdfXmlSubprocess.process adds ont-model ", System.currentTimeMillis() - startOntModel);
            long startField = System.currentTimeMillis();
            for (ISolrDataField field : this.fieldList) {
                long filed = System.currentTimeMillis();
                String q = null;
                if (field instanceof SparqlField) {
                    q = ((SparqlField)field).getQuery();
                    q = q.replaceAll("\\$GRAPH_NAME", (String)name);
                    q = q.replaceAll("\\$DEFAULT_URI", RESOLVE_URL);
                    Query query = QueryFactory.create((String)q);
                    log.trace((Object)("Executing SPARQL query:\n" + query.toString()));
                    QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
                    ResultSet results = qexec.execSelect();
                    while (results.hasNext()) {
                        SolrDoc solrDoc = null;
                        QuerySolution solution = results.next();
                        log.trace((Object)solution.toString());
                        if (solution.contains("pid")) {
                            String id = solution.getLiteral("pid").getString();
                            solrDoc = docs.get(id);
                            if (solrDoc == null) {
                                solrDoc = id.equals(resourceMapDocId) ? resourceMapDocument : new DummySolrDoc(id, null);
                                docs.put(id, solrDoc);
                            }
                        } else if (solution.contains("seriesId")) {
                            throw new RuntimeException("DataONE-Indexer shouldn't handle the sid queries");
                        }
                        if (!solution.contains(field.getName())) continue;
                        String value = solution.get(field.getName()).toString();
                        SolrElementField f = new SolrElementField(field.getName(), value);
                        if (solrDoc.hasFieldWithValue(f.getName(), f.getValue())) continue;
                        solrDoc.addField(f);
                    }
                }
                perfLog.log("RdfXmlSubprocess.process process the field " + field.getName(), System.currentTimeMillis() - filed);
            }
            perfLog.log("RdfXmlSubprocess.process process the fields total ", System.currentTimeMillis() - startField);
            perfLog.log("RdfXmlSubprocess.process() total take ", System.currentTimeMillis() - start);
        }
        finally {
            try {
                TripleStoreService.getInstance().destoryDataset(dataset);
            }
            catch (Exception e) {
                log.warn((Object)("A tdb directory can't be removed since " + e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public SolrDoc mergeWithIndexedDocument(SolrDoc indexDocument) throws IOException, EncoderException, XPathExpressionException {
        return this.processorUtility.mergeWithIndexedDocument(indexDocument, this.fieldsToMerge);
    }

    public List<String> getFieldsToMerge() {
        return this.fieldsToMerge;
    }

    public void setFieldsToMerge(List<String> fieldsToMerge) {
        this.fieldsToMerge = fieldsToMerge;
    }

    public HTTPService getHttpService() {
        return this.httpService;
    }

    public void setHttpService(HTTPService httpService) {
        this.httpService = httpService;
    }

    public SubprocessorUtility getProcessorUtility() {
        return this.processorUtility;
    }

    public void setProcessorUtility(SubprocessorUtility processorUtility) {
        this.processorUtility = processorUtility;
    }
}

