/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.osti_elink.v2.xml;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.ucsb.nceas.osti_elink.OSTIElinkException;
import edu.ucsb.nceas.osti_elink.OSTIElinkNotFoundException;
import edu.ucsb.nceas.osti_elink.OSTIElinkService;
import edu.ucsb.nceas.osti_elink.OSTIServiceFactory;
import edu.ucsb.nceas.osti_elink.exception.PropertyNotFound;
import edu.ucsb.nceas.osti_elink.v2.response.JsonResponseHandler;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.methods.HttpUriRequest;

public class OSTIv2XmlService
extends OSTIElinkService {
    public static final String WORKFLOW_STATUS = "workflow_status";
    public static final String SITE_URL = "site_url";
    public static final String OSTI_TOKEN_ENV_NAME = "METACAT_OSTI_TOKEN";
    public static final String BASE_URL_ENV_NAME = "METACAT_OSTI_BASE_URL";
    public static final String TOKEN_PATH_PROP_NAME = "ostiService.v2.tokenFilePath";
    public static final String V2XML_CONTEXT_ENV_NAME = "METACAT_OSTI_V2XML_CONTEXT";
    public static final String V2JSON_CONTEXT_ENV_NAME = "METACAT_OSTI_V2JSON_CONTEXT";
    public static final String DOI_QUERY_MAX_ATTEMPTS_ENV_NAME = "METACAT_OSTI_DOI_QUERY_MAX_ATTEMPTS";
    private static final String UPLOAD = "/upload";
    private static String v2XmlContext = "elink2xml";
    protected static String v2JsonContext = "elink2api";
    protected static final String SUBMIT_SUFFIX = "submit";
    protected static final String RECORDS = "records";
    protected static String token;
    protected static String queryURL;
    protected static String v2RecordsURL;
    protected static int maxAttempts;

    public OSTIv2XmlService(String username, String password, String baseURL) {
        super(username, password, baseURL);
    }

    public OSTIv2XmlService(String username, String password, String baseURL, Properties properties) throws PropertyNotFound, IOException, OSTIElinkException {
        super(username, password, baseURL);
        this.properties = properties;
        this.constructURLs();
        this.loadToken();
        String maxAttemptsStr = System.getenv(DOI_QUERY_MAX_ATTEMPTS_ENV_NAME);
        if (maxAttemptsStr != null && !maxAttemptsStr.trim().equals("")) {
            log.info((Object)("The max query attempts from env variable METACAT_OSTI_DOI_QUERY_MAX_ATTEMPTS is " + maxAttemptsStr));
            try {
                maxAttempts = Integer.parseInt(maxAttemptsStr);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("The max query attempt value specified in the env variable METACAT_OSTI_DOI_QUERY_MAX_ATTEMPTS is not a integer: " + e.getMessage() + ". So we still use the default value 40."));
                maxAttempts = 40;
            }
        }
    }

    @Override
    public String getStatus(String doi) throws OSTIElinkException {
        String status;
        String metadata = null;
        long start = System.currentTimeMillis();
        for (int i = 0; i <= maxAttempts; ++i) {
            try {
                metadata = this.getMetadata(doi);
                break;
            }
            catch (OSTIElinkNotFoundException e) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ex) {
                    log.warn((Object)("The thread waiting for the DOI searchable in the getStatus method was interrupted " + ex.getMessage()));
                }
                if (i < maxAttempts) continue;
                throw new OSTIElinkNotFoundException("The library tried " + maxAttempts + " times to query the status of " + doi + " from the OSTI service. However OSTI service still can't find it");
            }
        }
        long end = System.currentTimeMillis();
        log.warn((Object)("It waited " + (end - start) / 1000L + " seconds for doi " + doi + " to be searchable after minting it."));
        try {
            status = JsonResponseHandler.getPathValue(metadata, WORKFLOW_STATUS);
        }
        catch (JsonProcessingException e) {
            throw new OSTIElinkException(e.getMessage());
        }
        if (status == null) {
            throw new OSTIElinkException("There is no workflow_status for " + doi + " in the query result:\n" + metadata);
        }
        if (status.equals("SA")) {
            status = "Saved";
        }
        log.debug((Object)("The status of " + doi + " is " + status));
        return status;
    }

    protected void loadToken() throws PropertyNotFound, IOException {
        token = System.getenv(OSTI_TOKEN_ENV_NAME);
        if (token == null) {
            String token_path = OSTIServiceFactory.getProperty(TOKEN_PATH_PROP_NAME, this.properties);
            log.info((Object)("Can't get the token from the environmental variable OSTI_TOKEN and will read it from a file " + token_path));
            token = FileUtils.readFileToString((File)new File(token_path), (String)"UTF-8");
        } else {
            log.info((Object)"It got the token from the environmental variable - METACAT_OSTI_TOKEN");
        }
    }

    protected void constructURLs() throws OSTIElinkException {
        String jsonContext;
        String xmlContext;
        log.info((Object)("The base URL from the property file is " + this.baseURL));
        String url = System.getenv(BASE_URL_ENV_NAME);
        if (url != null && !url.trim().equals("")) {
            log.info((Object)("The base URL from the env variable METACAT_OSTI_BASE_URL is " + url + " and the value overwrites the one from the property file"));
            this.baseURL = url;
        }
        if (this.baseURL == null) {
            throw new OSTIElinkException("The base URL for the osti service is null");
        }
        if (!this.baseURL.endsWith("/")) {
            this.baseURL = this.baseURL + "/";
        }
        if ((xmlContext = System.getenv(V2XML_CONTEXT_ENV_NAME)) != null && !xmlContext.trim().equals("")) {
            log.info((Object)("The v2XmlContext was overwritten by the env variable METACAT_OSTI_V2XML_CONTEXT with value " + xmlContext));
            v2XmlContext = xmlContext;
        }
        if ((jsonContext = System.getenv(V2JSON_CONTEXT_ENV_NAME)) != null && !jsonContext.trim().equals("")) {
            log.info((Object)("The v2JsonContext was overwritten by the env variable METACAT_OSTI_V2JSON_CONTEXT with value " + jsonContext));
            v2JsonContext = jsonContext;
        }
        queryURL = this.baseURL + v2JsonContext;
        v2RecordsURL = queryURL + "/" + RECORDS;
        this.baseURL = this.baseURL + v2XmlContext + UPLOAD;
        log.info((Object)("The OSTI base url is " + this.baseURL + " , the query url is " + queryURL + " and the records url is " + v2RecordsURL));
    }

    @Override
    protected void setHeaders(HttpUriRequest request, String url) {
        if (url.contains(v2XmlContext + UPLOAD)) {
            log.debug((Object)(url + "is a v2xml request so it set be application/xml "));
            request.addHeader("Accept", "application/xml");
        } else {
            log.debug((Object)(url + "is a v2api json request so it set be application/json "));
            request.addHeader("Accept", "application/json");
            request.addHeader("Content-Type", "application/json");
        }
        request.addHeader("Authorization", "Bearer " + token);
    }

    @Override
    protected void setGetHeaders(HttpUriRequest request) {
        request.addHeader("Authorization", "Bearer " + token);
    }

    @Override
    protected String getMetadata(String identifier, String type) throws OSTIElinkException {
        String metadata = null;
        if (identifier != null && !identifier.trim().equals("")) {
            JsonNode node;
            identifier = OSTIv2XmlService.removeDOI(identifier);
            String url = null;
            try {
                url = queryURL + "/records?" + type + "=" + URLEncoder.encode("\"" + identifier + "\"", StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                throw new OSTIElinkException("OSTIv2XmlService.getMetadata - couldn't encode the query url: " + e.getMessage());
            }
            log.info((Object)("The url sending to the service is " + url));
            byte[] response = this.sendRequest(1, url);
            metadata = new String(response);
            log.info((Object)("The response for id " + identifier + " is\n " + metadata));
            if (metadata == null || metadata.trim().equals("")) {
                throw new OSTIElinkException("OSTIv2XmlService.getMetadata - the response is blank. It means the token is invalid for looking " + identifier + ", which type is " + type);
            }
            try {
                node = JsonResponseHandler.isResponseWithError(metadata);
            }
            catch (OSTIElinkException ee) {
                throw new OSTIElinkException("OSTIv2XmlService.getMetadata - can't get the metadata for id " + identifier + " since\n " + metadata);
            }
            if (JsonResponseHandler.isEmptyArray(node)) {
                throw new OSTIElinkNotFoundException("OSTIv2XmlService.getMetadata - OSTI can't find the identifier " + identifier + ", which type is " + type + " since\n " + metadata);
            }
        } else {
            throw new OSTIElinkException("OSTIv2XmlService.getMetadata - the given identifier can't be null or blank.");
        }
        return metadata;
    }

    @Override
    protected String parseOSTIidFromResponse(String metadata, String doi) throws OSTIElinkException {
        if (metadata == null || metadata.trim().equals("")) {
            throw new OSTIElinkException("The service can't parse the blank response to get the OSTI id for the DOI " + doi);
        }
        try {
            return JsonResponseHandler.getPathValue(metadata, "osti_id");
        }
        catch (JsonProcessingException e) {
            throw new OSTIElinkException(e.getMessage());
        }
    }

    protected String getBaseUrl() {
        return this.baseURL;
    }

    protected String getQueryURL() {
        return queryURL;
    }

    protected String getV2RecordsURLURL() {
        return v2RecordsURL;
    }

    protected int getMaxAttempts() {
        return maxAttempts;
    }

    @Override
    protected void handlePublishIdentifierCommand(String ostiId, String siteUrl) throws OSTIElinkException {
        String jsonMetadata = this.getMetadataFromOstiId(ostiId);
        log.debug((Object)("The metadata for osti_id " + ostiId + " is\n" + jsonMetadata));
        try {
            ObjectNode record = JsonResponseHandler.getFirstNodeInArray(jsonMetadata);
            record.remove(WORKFLOW_STATUS);
            record.put(SITE_URL, siteUrl);
            String newMetadata = record.toString();
            log.debug((Object)("The modified metadata (removing workflow_status and adding site_url is\n" + newMetadata));
            this.setJsonMetadata(ostiId, newMetadata);
        }
        catch (JsonProcessingException e) {
            throw new OSTIElinkException(e.getMessage());
        }
    }

    protected void setJsonMetadata(String osti_id, String jsonMetadata) throws OSTIElinkException {
        try {
            String url = v2RecordsURL + "/" + osti_id + "/" + SUBMIT_SUFFIX;
            byte[] response = this.sendRequest(2, url, jsonMetadata);
            String responseStr = new String(response);
            log.debug((Object)("The response from the OSTI service to set metadata for osti_id " + osti_id + " is:\n " + responseStr));
            JsonResponseHandler.isResponseWithError(responseStr);
        }
        catch (OSTIElinkException e) {
            throw new OSTIElinkException("Can't set the json metadata for osti_id " + osti_id + " since " + e.getMessage());
        }
    }

    static {
        maxAttempts = 40;
    }
}

