/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.osti_elink.v2.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.ucsb.nceas.osti_elink.OSTIElinkException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PublishIdentifierCommand
extends edu.ucsb.nceas.osti_elink.PublishIdentifierCommand {
    private static final Log log = LogFactory.getLog(PublishIdentifierCommand.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    public static final String WORKFLOW_STATUS = "workflow_status";
    public static final String SITE_URL = "site_url";
    private static final String OSTI_ID = "osti_id";
    public static final String RELEASED_STATUS = "R";
    private boolean hasSiteURL = false;
    private JsonNode recordNode;

    @Override
    public boolean parse(String json) throws OSTIElinkException {
        if (json == null || json.trim().isEmpty()) {
            log.debug((Object)"v2.json.PublishIdentifierCommand: Received empty JSON string");
            return false;
        }
        try {
            JsonNode rootNode = mapper.readTree(json);
            if (rootNode.isArray() && rootNode.size() > 0) {
                this.recordNode = rootNode.get(0);
                log.debug((Object)"v2.json.PublishIdentifierCommand: Processing first record from array of records");
            } else {
                this.recordNode = rootNode;
            }
            if (!this.recordNode.has(SITE_URL)) {
                log.debug((Object)"v2.json.PublishIdentifierCommand: JSON doesn't have a 'site_url' field");
                return false;
            }
            log.debug((Object)"JSON does have the 'site_url' field");
            this.hasSiteURL = true;
            this.url = this.recordNode.get(SITE_URL).asText();
            log.debug((Object)("The request has a site_url: " + this.url));
            if (this.recordNode.size() != 1) {
                log.debug((Object)("The request has a site_url: " + this.url + " but also has more fields than that. So it is not a pure publish request."));
                return false;
            }
            return true;
        }
        catch (JsonProcessingException e) {
            log.debug((Object)("v2.json.PublishIdentifierCommand: Failed to parse JSON: " + e.getMessage()));
            throw new OSTIElinkException("v2.json.PublishIdentifierCommand: Failed to parse JSON metadata: " + e.getMessage());
        }
    }

    public boolean hasSiteURL() {
        return this.hasSiteURL;
    }

    public JsonNode getRecordNode() {
        return this.recordNode;
    }
}

