/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.osti_elink.v2.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.ucsb.nceas.osti_elink.OSTIElinkAuthenticationException;
import edu.ucsb.nceas.osti_elink.OSTIElinkException;
import edu.ucsb.nceas.osti_elink.OSTIElinkNotFoundException;
import edu.ucsb.nceas.osti_elink.OSTIElinkService;
import edu.ucsb.nceas.osti_elink.OSTIServiceFactory;
import edu.ucsb.nceas.osti_elink.exception.PropertyNotFound;
import edu.ucsb.nceas.osti_elink.v2.json.PublishIdentifierCommand;
import edu.ucsb.nceas.osti_elink.v2.response.JsonResponseHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.methods.HttpUriRequest;

public class OSTIv2JsonService
extends OSTIElinkService {
    private static final String DEFUALT_BASE_URL = "https://www.osti.gov";
    public static final String BASE_URL_ENV_NAME = "METACAT_OSTI_BASE_URL";
    public static final String OSTI_TOKEN_ENV_NAME = "METACAT_OSTI_TOKEN";
    public static final String TOKEN_PATH_PROP_NAME = "ostiService.v2.tokenFilePath";
    protected static String token;
    protected static final String v2JsonContext = "elink2api";
    public static final String V2JSON_CONTEXT_ENV_NAME = "METACAT_OSTI_V2JSON_CONTEXT";
    protected static final String DOI_RECORDS_ENDPOINT = "records";
    protected static final String DOI_RECORDS_ENDPONT_SAVE_PARAMETER = "save";
    protected static final String DOI_RECORDS_ENDPONT_SUBMIT_PARAMETER = "submit";
    protected String QUERY_URL = null;
    protected static String FULL_RECORDS_ENDPOINT_URL;
    protected static String MINT_DOI_ENDPOINT_URL;
    protected static String GET_METADATA_ENDPOINT_URL;
    protected static String SET_METADATA_ENDPOINT_URL;
    protected static String UPDATE_METADATA_ENDPOINT_URL;
    protected static String PUBLISH_DOI_ENDPOINT_URL;
    public static final String DOI_QUERY_MAX_ATTEMPTS_ENV_NAME = "METACAT_OSTI_DOI_QUERY_MAX_ATTEMPTS";
    protected static int maxAttempts;
    public static final String WORKFLOW_STATUS = "workflow_status";
    public static final String SITE_URL = "site_url";
    private JsonNode minimalMetadataNode = null;
    private String originalDefaultSiteCode = null;
    private String currentDefaultSiteCode = null;
    protected static final String DEFAULT_MINIMAL_METADATA_FILE_JSON = "minimal-osti.json";
    public static final String MINIMAL_METADATA_FILE_ENV_NAME = "METACAT_OSTI_MINIMAL_METADATA_FILE";
    protected static final String CONTRACT_NUMBER_FIELD = "CN_DOE";
    protected static final String DEFAULT_CONTRACT_NUMBER = "AC02-05CH11231";

    public OSTIv2JsonService(String username, String password, String BASE_URL) {
        super(username, password, BASE_URL);
    }

    public OSTIv2JsonService(String username, String password, String BASE_URL, Properties properties) throws PropertyNotFound, IOException, OSTIElinkException {
        super(username, password, BASE_URL);
        this.properties = properties;
        this.constructURLs();
        this.loadToken();
        String maxAttemptsStr = System.getenv(DOI_QUERY_MAX_ATTEMPTS_ENV_NAME);
        if (maxAttemptsStr != null && !maxAttemptsStr.trim().equals("")) {
            log.info((Object)("The max query attempts from env variable METACAT_OSTI_DOI_QUERY_MAX_ATTEMPTS is " + maxAttemptsStr));
            try {
                maxAttempts = Integer.parseInt(maxAttemptsStr);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("The max query attempt value specified in the env variable METACAT_OSTI_DOI_QUERY_MAX_ATTEMPTS is not a integer: " + e.getMessage() + ". So we still use the default value 40."));
                maxAttempts = 40;
            }
        }
    }

    @Override
    public String getStatus(String doi) throws OSTIElinkException {
        String status;
        String metadata = null;
        long start = System.currentTimeMillis();
        for (int i = 0; i <= maxAttempts; ++i) {
            try {
                metadata = this.getMetadata(doi);
                break;
            }
            catch (OSTIElinkNotFoundException e) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ex) {
                    log.warn((Object)("The thread waiting for the DOI searchable in the getStatus method was interrupted " + ex.getMessage()));
                }
                if (i < maxAttempts) continue;
                throw new OSTIElinkNotFoundException("The library tried " + maxAttempts + " times to query the status of " + doi + " from the OSTI service. However OSTI service still can't find it");
            }
        }
        long end = System.currentTimeMillis();
        log.warn((Object)("It waited " + (end - start) / 1000L + " seconds for doi " + doi + " to be searchable after minting it."));
        try {
            status = JsonResponseHandler.getPathValue(metadata, WORKFLOW_STATUS);
        }
        catch (JsonProcessingException e) {
            throw new OSTIElinkException(e.getMessage());
        }
        if (status == null) {
            throw new OSTIElinkException("There is no workflow_status for " + doi + " in the query result:\n" + metadata);
        }
        if (status.equals("SA")) {
            status = "Saved";
        }
        log.debug((Object)("The status of " + doi + " is " + status));
        return status;
    }

    @Override
    protected String getMetadata(String identifier, String type) throws OSTIElinkException {
        String metadata = null;
        String getMetadataUrl = null;
        if (identifier != null && !identifier.trim().equals("")) {
            JsonNode node;
            String extractedIdentifier = OSTIv2JsonService.removeDOI(identifier);
            try {
                getMetadataUrl = FULL_RECORDS_ENDPOINT_URL + "?" + type + "=" + URLEncoder.encode("\"" + extractedIdentifier + "\"", StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                throw new OSTIElinkException("OSTIv2JsonService.getMetadata - couldn't encode the getMetadataUrl: " + e.getMessage());
            }
            log.info((Object)("The query sent to get metadata is " + getMetadataUrl));
            try {
                byte[] response = this.sendRequest(1, getMetadataUrl);
                metadata = new String(response);
                log.info((Object)("OSTIv2JsonService.getMetadata: Successfully retrieved metadata for " + extractedIdentifier + "\n metadata: " + metadata));
            }
            catch (OSTIElinkAuthenticationException e) {
                String contextMsg = "OSTIv2JsonService.getMetadata - Failed to retrieve metadata for identifier '" + identifier + "' (" + type + "): " + e.getMessage() + ". Please check your OSTI token configuration.";
                log.error((Object)contextMsg);
                throw new OSTIElinkAuthenticationException(e.getStatusCode(), contextMsg);
            }
            if (metadata == null || metadata.trim().equals("")) {
                throw new OSTIElinkException("OSTIv2JsonService.getMetadata - the response is blank. It means the token is invalid for looking " + extractedIdentifier + ", which type is " + type);
            }
            try {
                node = JsonResponseHandler.isResponseWithError(metadata);
            }
            catch (OSTIElinkException ee) {
                throw new OSTIElinkException("OSTIv2JsonService.getMetadata - can't get the metadata for id " + identifier + " since\n " + metadata);
            }
            if (JsonResponseHandler.isEmptyArray(node)) {
                throw new OSTIElinkNotFoundException("OSTIv2JsonService.getMetadata - OSTI can't find the identifier " + identifier + ", which type is " + type + " since\n " + metadata);
            }
        } else {
            throw new OSTIElinkException("OSTIv2JsonService.getMetadata - the given identifier can't be null or blank.");
        }
        return metadata;
    }

    @Override
    public void setMetadata(String doi, String doiPrefix, String metadataJson) throws OSTIElinkException {
        String ostiId = this.getOstiId(doi, doiPrefix);
        log.debug((Object)("OSTIv2JsonService.setMetadata - Processing metadata update for DOI " + doi + " with OSTI ID " + ostiId + ". Metadata:\n" + metadataJson));
        PublishIdentifierCommand command = new PublishIdentifierCommand();
        if (command.parse(metadataJson)) {
            log.info((Object)("Detected publish identifier command for " + doi + ". Will handle via specialized route."));
            this.handlePublishIdentifierCommand(ostiId, command.getUrl());
        } else if (command.hasSiteURL()) {
            log.info((Object)("Detected the site url field for " + doi + ". Will handle via the submit route."));
            this.handleSubmit(ostiId, command.getUrl(), (ObjectNode)command.getRecordNode());
        } else {
            log.info((Object)"Standard metadata update (no site url)");
            String updateUrl = UPDATE_METADATA_ENDPOINT_URL + "/" + ostiId + "/" + DOI_RECORDS_ENDPONT_SAVE_PARAMETER;
            log.debug((Object)("OSTIv2JsonService.setMetadata - Sending metadata update to: " + updateUrl));
            byte[] response = this.sendRequest(5, updateUrl, metadataJson);
            String responseStr = new String(response);
            log.debug((Object)("OSTIv2JsonService.setMetadata - Response from OSTI service: " + responseStr));
            try {
                JsonNode responseNode = JsonResponseHandler.isResponseWithError(responseStr);
                if (responseNode == null || !responseNode.has(WORKFLOW_STATUS)) {
                    throw new OSTIElinkException("OSTIv2JsonService.setMetadata - Invalid or incomplete response");
                }
                log.info((Object)("OSTIv2JsonService.setMetadata - Successfully updated metadata for DOI " + doi + " (OSTI ID: " + ostiId + "). New status: " + responseNode.get(WORKFLOW_STATUS).asText()));
            }
            catch (OSTIElinkException e) {
                log.error((Object)("OSTIv2JsonService.setMetadata - Error updating metadata: " + e.getMessage()));
                throw new OSTIElinkException("OSTIv2JsonService.setMetadata - Error:\n" + responseStr);
            }
        }
    }

    @Override
    public String mintIdentifier(String siteCode) throws OSTIElinkException {
        String DoiIdentifier = null;
        String minimalMetadata = this.buildMinimalMetadata(siteCode);
        log.debug((Object)("the minimal metadata is " + minimalMetadata));
        log.debug((Object)("the MINT_DOI_ENDPOINT_URL is " + MINT_DOI_ENDPOINT_URL));
        byte[] response = this.sendRequest(3, MINT_DOI_ENDPOINT_URL, minimalMetadata);
        log.debug((Object)("OSTIv2JsonService.mintIdentifier - the response from the OSTI service is:\n " + new String(response)));
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode rootNode = mapper.readTree(response);
            if (rootNode.has(WORKFLOW_STATUS)) {
                String status = rootNode.get(WORKFLOW_STATUS).asText();
                String doi = rootNode.get("doi").asText();
                if (status != null && status.equalsIgnoreCase("SA") && doi != null && !doi.trim().equals("")) {
                    DoiIdentifier = "doi:" + doi;
                }
            } else {
                System.out.println("OSTIv2JsonService.mintIdentifier - ERROR: Status field not found");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OSTIElinkException("OSTIv2JsonService.mintIdentifier - Error:  " + new String(response));
        }
        log.debug((Object)("OSTIv2JsonService.mintIdentifier(): DoiIdentifier = " + DoiIdentifier));
        return DoiIdentifier;
    }

    @Override
    protected String buildMinimalMetadata(String siteCode) throws OSTIElinkException {
        String metadataStr = null;
        ObjectMapper mapper = new ObjectMapper();
        if (this.minimalMetadataNode == null) {
            String metadataFileName = System.getenv(MINIMAL_METADATA_FILE_ENV_NAME);
            if (metadataFileName == null || metadataFileName.trim().isEmpty()) {
                metadataFileName = DEFAULT_MINIMAL_METADATA_FILE_JSON;
            }
            try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(metadataFileName);){
                if (is == null) {
                    throw new IOException("Resource not found: " + metadataFileName);
                }
                this.minimalMetadataNode = mapper.readTree(is);
                if (this.minimalMetadataNode.has("site_ownership_code")) {
                    this.currentDefaultSiteCode = this.originalDefaultSiteCode = this.minimalMetadataNode.get("site_ownership_code").asText();
                    log.debug((Object)("OSTIElink.buildMinimalMetadata - Original site code: " + this.originalDefaultSiteCode));
                }
            }
            catch (IOException e) {
                throw new OSTIElinkException("OSTIElink.buildMinimalMetadata - Error loading file: " + e.getMessage());
            }
        }
        if (siteCode != null && !siteCode.trim().equals("")) {
            this.modifySiteCode(siteCode);
        } else if (!this.originalDefaultSiteCode.equals(this.currentDefaultSiteCode)) {
            this.modifySiteCode(this.originalDefaultSiteCode);
        }
        try {
            metadataStr = mapper.writeValueAsString((Object)this.minimalMetadataNode);
            log.debug((Object)("OSTIElink.buildMinimalMetadata - Final metadata: " + metadataStr));
        }
        catch (JsonProcessingException e) {
            throw new OSTIElinkException("OSTIElink.buildMinimalMetadata - Error serializing JSON: " + e.getMessage());
        }
        return metadataStr;
    }

    private void modifySiteCode(String siteCode) throws OSTIElinkException {
        if (this.minimalMetadataNode == null) {
            throw new OSTIElinkException("OSTIElink.modifySiteCode - Minimal metadata not loaded");
        }
        if (siteCode == null || siteCode.trim().equals("")) {
            throw new OSTIElinkException("OSTIElink.modifySiteCode - Site code cannot be null or empty");
        }
        try {
            ObjectNode objectNode = (ObjectNode)this.minimalMetadataNode;
            objectNode.put("site_ownership_code", siteCode);
            this.currentDefaultSiteCode = siteCode;
            log.debug((Object)("OSTIElink.modifySiteCode - Updated site_ownership_code to: " + siteCode));
        }
        catch (Exception e) {
            throw new OSTIElinkException("OSTIElink.modifySiteCode - Error modifying site code: " + e.getMessage());
        }
    }

    @Override
    protected String parseOSTIidFromResponse(String metadata, String doi) throws OSTIElinkException {
        if (metadata == null || metadata.trim().equals("")) {
            throw new OSTIElinkException("The service can't parse the blank response to get the OSTI id for the DOI " + doi);
        }
        try {
            return JsonResponseHandler.getPathValue(metadata, "osti_id");
        }
        catch (JsonProcessingException e) {
            throw new OSTIElinkException(e.getMessage());
        }
    }

    protected void loadToken() throws PropertyNotFound, IOException {
        token = System.getenv(OSTI_TOKEN_ENV_NAME);
        if (token == null) {
            String token_path = OSTIServiceFactory.getProperty(TOKEN_PATH_PROP_NAME, this.properties);
            log.info((Object)("OSTIv2JsonService.loadToken(): Can't get the token from the environmental variable OSTI_TOKEN and will read it from a file " + token_path));
            token = FileUtils.readFileToString((File)new File(token_path), (String)"UTF-8");
        } else {
            log.info((Object)"OSTIv2JsonService.loadToken(): It got the token from the environmental variable - METACAT_OSTI_TOKEN");
        }
    }

    @Override
    protected void setHeaders(HttpUriRequest request, String url) {
        if (url.contains(v2JsonContext)) {
            log.debug((Object)("OSTIv2JsonService.setHeaders():" + url + "is a v2 elink2api json request, so application/json has been added as the header"));
            request.addHeader("Accept", "application/json");
            request.addHeader("Content-Type", "application/json");
        }
        request.addHeader("Authorization", "Bearer " + token);
    }

    @Override
    protected void setGetHeaders(HttpUriRequest request) {
        request.addHeader("Authorization", "Bearer " + token);
        request.addHeader("Accept", "application/json");
    }

    @Override
    protected void handlePublishIdentifierCommand(String ostiId, String siteUrl) throws OSTIElinkException {
        String jsonMetadata = this.getMetadataFromOstiId(ostiId);
        log.debug((Object)("OSTIv2JsonService.handlePublishIdentifierCommand(): The metadata for osti_id " + ostiId + " is\n" + jsonMetadata));
        try {
            ObjectNode record = JsonResponseHandler.getFirstNodeInArray(jsonMetadata);
            this.handleSubmit(ostiId, siteUrl, record);
        }
        catch (JsonProcessingException e) {
            throw new OSTIElinkException("Error processing metadata for OSTI ID " + ostiId + ": " + e.getMessage());
        }
    }

    protected void handleSubmit(String ostiId, String siteUrl, ObjectNode record) throws OSTIElinkException {
        record.remove(WORKFLOW_STATUS);
        record.put(SITE_URL, siteUrl);
        OSTIv2JsonService.ensureRequiredFieldsInPublish(record);
        String publishUrl = PUBLISH_DOI_ENDPOINT_URL + "/" + ostiId + "/" + DOI_RECORDS_ENDPONT_SUBMIT_PARAMETER;
        String newMetadata = record.toString();
        log.debug((Object)("Sending to publish endpoint: " + publishUrl + "\nThe modified metadata (removing workflow_status and adding site_url) is:\n" + newMetadata));
        byte[] response = this.sendRequest(5, publishUrl, newMetadata);
        String responseStr = new String(response);
        log.debug((Object)("Response from OSTI service: " + responseStr));
        JsonResponseHandler.isResponseWithError(responseStr);
        log.info((Object)("Successfully published OSTI ID " + ostiId));
    }

    protected void constructURLs() throws OSTIElinkException {
        log.info((Object)("OSTIv2JsonService.constructURLs(): The base URL from the property file is " + this.baseURL));
        String url = System.getenv(BASE_URL_ENV_NAME);
        log.debug((Object)("OSTIv2JsonService.constructURLs(): url is " + url));
        if (url != null && !url.trim().equals("")) {
            log.info((Object)("OSTIv2JsonService.constructURLs(): The base URL from the env variable METACAT_OSTI_BASE_URL is " + url + " and the value overwrites the one from the property file"));
            this.baseURL = url;
        }
        if (this.baseURL == null || this.baseURL.trim().equals("")) {
            this.baseURL = DEFUALT_BASE_URL;
        }
        if (!this.baseURL.endsWith("/")) {
            this.baseURL = this.baseURL + "/";
        }
        this.QUERY_URL = this.baseURL + v2JsonContext;
        FULL_RECORDS_ENDPOINT_URL = this.QUERY_URL + "/" + DOI_RECORDS_ENDPOINT;
        MINT_DOI_ENDPOINT_URL = FULL_RECORDS_ENDPOINT_URL + "/" + DOI_RECORDS_ENDPONT_SAVE_PARAMETER;
        GET_METADATA_ENDPOINT_URL = FULL_RECORDS_ENDPOINT_URL;
        SET_METADATA_ENDPOINT_URL = FULL_RECORDS_ENDPOINT_URL;
        UPDATE_METADATA_ENDPOINT_URL = FULL_RECORDS_ENDPOINT_URL;
        PUBLISH_DOI_ENDPOINT_URL = FULL_RECORDS_ENDPOINT_URL;
    }

    protected static void ensureRequiredFieldsInPublish(ObjectNode root) {
        ArrayNode sponsorIds;
        JsonNode sIdsNode;
        ArrayNode orgs;
        ArrayNode topIds;
        if (root == null) {
            return;
        }
        Function<String, ObjectNode> makeIdentifier = value -> {
            ObjectNode obj = JsonNodeFactory.instance.objectNode();
            obj.put("type", CONTRACT_NUMBER_FIELD);
            obj.put("value", value);
            return obj;
        };
        JsonNode idsNode = root.get("identifiers");
        if (idsNode != null && idsNode.isArray()) {
            topIds = (ArrayNode)idsNode;
        } else {
            topIds = JsonNodeFactory.instance.arrayNode();
            root.set("identifiers", (JsonNode)topIds);
        }
        JsonNode orgsNode = root.get("organizations");
        if (orgsNode != null && orgsNode.isArray()) {
            orgs = (ArrayNode)orgsNode;
        } else {
            orgs = JsonNodeFactory.instance.arrayNode();
            root.set("organizations", (JsonNode)orgs);
        }
        ObjectNode sponsor = null;
        for (JsonNode org : orgs) {
            if (!org.hasNonNull("type") || !"SPONSOR".equals(org.get("type").asText())) continue;
            sponsor = (ObjectNode)org;
            break;
        }
        if (sponsor == null) {
            sponsor = JsonNodeFactory.instance.objectNode();
            sponsor.put("type", "SPONSOR");
            sponsor.put("name", "Unknown Sponsor");
            orgs.add((JsonNode)sponsor);
        }
        if ((sIdsNode = sponsor.get("identifiers")) != null && sIdsNode.isArray()) {
            sponsorIds = (ArrayNode)sIdsNode;
        } else {
            sponsorIds = JsonNodeFactory.instance.arrayNode();
            sponsor.set("identifiers", (JsonNode)sponsorIds);
        }
        String topValue = OSTIv2JsonService.findDOEContractValue(topIds, CONTRACT_NUMBER_FIELD);
        String sponsorValue = OSTIv2JsonService.findDOEContractValue(sponsorIds, CONTRACT_NUMBER_FIELD);
        if (topValue != null && sponsorValue != null) {
            return;
        }
        if (topValue == null && sponsorValue != null) {
            topIds.add((JsonNode)makeIdentifier.apply(sponsorValue));
        } else if (topValue != null && sponsorValue == null) {
            sponsorIds.add((JsonNode)makeIdentifier.apply(topValue));
        } else {
            topIds.add((JsonNode)makeIdentifier.apply(DEFAULT_CONTRACT_NUMBER));
            sponsorIds.add((JsonNode)makeIdentifier.apply(DEFAULT_CONTRACT_NUMBER));
        }
    }

    private static String findDOEContractValue(ArrayNode arr, String type) {
        for (JsonNode id : arr) {
            if (!id.hasNonNull("type") || !type.equals(id.get("type").asText()) || !id.hasNonNull("value") || id.get("value").asText().isEmpty()) continue;
            return id.get("value").asText();
        }
        return null;
    }

    protected String getBaseUrl() {
        return this.baseURL;
    }

    protected String getQueryUrl() {
        return this.QUERY_URL;
    }

    protected String getRecordsEndpointURL() {
        return FULL_RECORDS_ENDPOINT_URL;
    }

    protected int getMaxAttempts() {
        return maxAttempts;
    }

    static {
        FULL_RECORDS_ENDPOINT_URL = null;
        MINT_DOI_ENDPOINT_URL = null;
        GET_METADATA_ENDPOINT_URL = null;
        SET_METADATA_ENDPOINT_URL = null;
        UPDATE_METADATA_ENDPOINT_URL = null;
        PUBLISH_DOI_ENDPOINT_URL = null;
        maxAttempts = 40;
    }
}

