/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.osti_elink.v1;

import edu.ucsb.nceas.osti_elink.OSTIElinkException;
import edu.ucsb.nceas.osti_elink.OSTIElinkService;
import org.apache.http.client.methods.HttpUriRequest;
import org.w3c.dom.Document;

public class OSTIService
extends OSTIElinkService {
    public OSTIService(String username, String password, String baseURL) {
        super(username, password, baseURL);
    }

    @Override
    protected void setHeaders(HttpUriRequest request, String url) {
        request.addHeader("Accept", "application/xml");
        request.addHeader("Authorization", "Basic " + new String(this.encodedAuthStr));
    }

    @Override
    protected void setGetHeaders(HttpUriRequest request) {
        this.setHeaders(request, null);
    }

    @Override
    protected String parseOSTIidFromResponse(String metadata, String doi) throws OSTIElinkException {
        if (metadata == null || metadata.trim().equals("")) {
            throw new OSTIElinkException("The service can't parse the blank response to get the OSTI id for the DOI " + doi);
        }
        Document doc = OSTIService.generateDOM(metadata.getBytes());
        return this.getElementValue(doc, "osti_id");
    }

    @Override
    protected void handlePublishIdentifierCommand(String ostiId, String siteUrl) {
        log.debug((Object)"V1 service does nothing in the handlePublishIdentifierCommand since it should never be called");
    }
}

