/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.osti_elink;

import edu.ucsb.nceas.osti_elink.OSTIElinkException;
import edu.ucsb.nceas.osti_elink.OSTIElinkService;
import edu.ucsb.nceas.osti_elink.exception.ClassNotSupported;
import edu.ucsb.nceas.osti_elink.exception.PropertyNotFound;
import edu.ucsb.nceas.osti_elink.v2.json.OSTIv2JsonService;
import edu.ucsb.nceas.osti_elink.v2.xml.OSTIv2XmlService;
import java.io.IOException;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OSTIServiceFactory {
    public static final String OSTISERVICE_CLASSNAME_PROPERTY = "ostiService.className";
    public static final String OSTISERVICE_CLASSNAME_ENV_NAME = "METACAT_OSTI_SERVICE_CLASS_NAME";
    private static final Log log = LogFactory.getLog(OSTIServiceFactory.class);

    public static OSTIElinkService getOSTIElinkService(Properties properties) throws IllegalArgumentException, PropertyNotFound, ClassNotFoundException, ClassNotSupported, IOException, OSTIElinkException, ParserConfigurationException {
        OSTIElinkService service;
        String className = System.getenv(OSTISERVICE_CLASSNAME_ENV_NAME);
        if (className == null) {
            try {
                className = OSTIServiceFactory.getProperty(OSTISERVICE_CLASSNAME_PROPERTY, properties);
                log.info((Object)("The class name " + className + " is set by the property file "));
            }
            catch (PropertyNotFound e) {
                log.info((Object)"We cannot find the OSTI service name from neither the evn variable METACAT_OSTI_SERVICE_CLASS_NAMEnor the properties file. So we will use the default one: edu.ucsb.nceas.osti_elink.v2.json.OSTIv2JsonService");
                className = "edu.ucsb.nceas.osti_elink.v2.json.OSTIv2JsonService";
            }
        } else {
            log.info((Object)("The class name " + className + " is set by the environmental variable " + OSTISERVICE_CLASSNAME_ENV_NAME));
        }
        String baseURL = OSTIServiceFactory.getProperty("guid.doi.baseurl", properties);
        if (className.equals("edu.ucsb.nceas.osti_elink.v2.xml.OSTIv2XmlService")) {
            service = new OSTIv2XmlService(null, null, baseURL, properties);
            log.info((Object)("The OSTI service class is v2xml: " + service.getClass().getName()));
        } else if (className.equals("edu.ucsb.nceas.osti_elink.v2.json.OSTIv2JsonService")) {
            service = new OSTIv2JsonService(null, null, baseURL, properties);
            log.info((Object)("The OSTI service class is v2json: " + service.getClass().getName()));
        } else {
            throw new ClassNotSupported("OSTIService does not support the class " + className);
        }
        return service;
    }

    public static String getProperty(String propertyName, Properties properties) throws IllegalArgumentException, PropertyNotFound {
        if (propertyName == null || propertyName.trim().equals("")) {
            throw new IllegalArgumentException("The propertyName should not be null or blank in the getProperty method.");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("The parameter properties should not be null or blank in the getProperty method.");
        }
        String value = properties.getProperty(propertyName);
        if (value == null || value.trim().equals("")) {
            throw new PropertyNotFound("The property of " + propertyName + " not found");
        }
        return value;
    }
}

