/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.resourcemap;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.apache.log4j.Logger;
import org.dataone.cn.indexer.object.ObjectManager;
import org.dataone.cn.indexer.resourcemap.IndexVisibilityDelegate;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.exceptions.MarshallingException;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.SystemMetadata;

public class IndexVisibilityDelegateImpl
implements IndexVisibilityDelegate {
    private static Logger logger = Logger.getLogger((String)IndexVisibilityDelegateImpl.class.getName());

    @Override
    public boolean isDocumentVisible(Identifier pid) {
        boolean visible = false;
        try {
            SystemMetadata systemMetadata = ObjectManager.getInstance().getSystemMetadata(pid.getValue());
            if (systemMetadata == null) {
                return true;
            }
            if (SolrDoc.visibleInIndex(systemMetadata)) {
                visible = true;
            }
        }
        catch (NullPointerException npe) {
            logger.warn((Object)("Could not get visible value for pid: " + pid.getValue() + " since " + npe.getMessage()));
        }
        catch (InvalidToken e) {
            logger.warn((Object)("Could not get visible value for pid: " + pid.getValue() + " since " + e.getMessage()));
        }
        catch (NotAuthorized e) {
            logger.warn((Object)("Could not get visible value for pid: " + pid.getValue() + " since " + e.getMessage()));
        }
        catch (NotImplemented e) {
            logger.warn((Object)("Could not get visible value for pid: " + pid.getValue() + " since " + e.getMessage()));
        }
        catch (ServiceFailure e) {
            logger.warn((Object)("Could not get visible value for pid: " + pid.getValue() + " since " + e.getMessage()));
        }
        catch (NotFound e) {
            logger.warn((Object)("Could not get visible value for pid: " + pid.getValue() + " since " + e.getMessage()));
        }
        catch (InstantiationException e) {
            logger.warn((Object)("Could not get visible value for pid: " + pid.getValue() + " since " + e.getMessage()));
        }
        catch (IllegalAccessException e) {
            logger.warn((Object)("Could not get visible value for pid: " + pid.getValue() + " since " + e.getMessage()));
        }
        catch (IOException e) {
            logger.warn((Object)("Could not get visible value for pid: " + pid.getValue() + " since " + e.getMessage()));
        }
        catch (MarshallingException e) {
            logger.warn((Object)("Could not get visible value for pid: " + pid.getValue() + " since " + e.getMessage()));
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn((Object)("Could not get visible value for pid: " + pid.getValue() + " since " + e.getMessage()));
        }
        return visible;
    }

    @Override
    public boolean documentExists(Identifier pid) {
        boolean exists = false;
        try {
            SystemMetadata systemMetadata = ObjectManager.getInstance().getSystemMetadata(pid.getValue());
            if (systemMetadata == null) {
                return true;
            }
            exists = true;
        }
        catch (NullPointerException npe) {
            logger.warn((Object)("Could not get visible value for pid: " + pid.getValue()));
        }
        catch (InvalidToken e) {
            logger.warn((Object)("Could not get visible value for pid: " + pid.getValue() + " since " + e.getMessage()));
        }
        catch (NotAuthorized e) {
            logger.warn((Object)("Could not get visible value for pid: " + pid.getValue() + " since " + e.getMessage()));
        }
        catch (NotImplemented e) {
            logger.warn((Object)("Could not get visible value for pid: " + pid.getValue() + " since " + e.getMessage()));
        }
        catch (ServiceFailure e) {
            logger.warn((Object)("Could not get visible value for pid: " + pid.getValue() + " since " + e.getMessage()));
        }
        catch (NotFound e) {
            logger.warn((Object)("Could not get visible value for pid: " + pid.getValue() + " since " + e.getMessage()));
        }
        catch (InstantiationException e) {
            logger.warn((Object)("Could not get visible value for pid: " + pid.getValue() + " since " + e.getMessage()));
        }
        catch (IllegalAccessException e) {
            logger.warn((Object)("Could not get visible value for pid: " + pid.getValue() + " since " + e.getMessage()));
        }
        catch (IOException e) {
            logger.warn((Object)("Could not get visible value for pid: " + pid.getValue() + " since " + e.getMessage()));
        }
        catch (MarshallingException e) {
            logger.warn((Object)("Could not get visible value for pid: " + pid.getValue() + " since " + e.getMessage()));
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn((Object)("Could not get visible value for pid: " + pid.getValue() + " since " + e.getMessage()));
        }
        return exists;
    }
}

