/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dataone.cn.indexer.parser.ISolrField;
import org.dataone.cn.indexer.parser.SolrField;
import org.dataone.cn.indexer.parser.utility.TemporalPeriodParsingUtility;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.w3c.dom.Document;

public class TemporalPeriodSolrField
extends SolrField
implements ISolrField {
    private static Logger log = Logger.getLogger(TemporalPeriodSolrField.class);
    public static final String BEGIN_FIELD_NAME = "beginDate";
    public static final String END_FIELD_NAME = "endDate";
    private static TemporalPeriodParsingUtility temporalParsingUtil = new TemporalPeriodParsingUtility();

    public TemporalPeriodSolrField() {
    }

    public TemporalPeriodSolrField(String xpath) {
        this.xpath = xpath;
    }

    @Override
    public List<SolrElementField> getFields(Document doc, String identifier) throws Exception {
        ArrayList<SolrElementField> fields = new ArrayList<SolrElementField>();
        String textValue = temporalParsingUtil.extractTextValue(doc, this.xPathExpression);
        String scheme = temporalParsingUtil.getScheme(textValue);
        if (scheme != null && !scheme.equalsIgnoreCase("W3C-DTF")) {
            log.warn((Object)("Scheme \"" + scheme + "\" may not be supported for pid " + identifier + ". Currently supporting: W3C-DTF"));
        }
        String startDate = temporalParsingUtil.getFormattedStartDate(textValue, scheme);
        String endDate = temporalParsingUtil.getFormattedEndDate(textValue, scheme);
        if (startDate == null && endDate == null) {
            log.error((Object)("Couldn't extract 'start' or 'end' date for pid " + identifier + ". Temporal pattern of type period needs to contain at least one of these. Value was: " + textValue));
            return fields;
        }
        if (startDate != null && endDate == null) {
            endDate = startDate;
        }
        if (endDate != null && startDate == null) {
            startDate = endDate;
        }
        SolrElementField beginField = new SolrElementField();
        beginField.setName(BEGIN_FIELD_NAME);
        beginField.setValue(startDate);
        fields.add(beginField);
        SolrElementField endField = new SolrElementField();
        endField.setName(END_FIELD_NAME);
        endField.setValue(endDate);
        fields.add(endField);
        return fields;
    }
}

