/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.object;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.log4j.Logger;
import org.dataone.client.auth.AuthTokenSession;
import org.dataone.client.exception.ClientSideException;
import org.dataone.client.rest.HttpMultipartRestClient;
import org.dataone.client.rest.MultipartRestClient;
import org.dataone.client.v2.impl.MultipartCNode;
import org.dataone.client.v2.impl.MultipartD1Node;
import org.dataone.client.v2.impl.MultipartMNode;
import org.dataone.configuration.Settings;
import org.dataone.exceptions.MarshallingException;
import org.dataone.indexer.storage.Storage;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.util.TypeMarshaller;

public class ObjectManager {
    private static ObjectManager manager = null;
    private static String nodeBaseURL = Settings.getConfiguration().getString("dataone.mn.baseURL");
    private static String DataONEauthToken = null;
    private static Logger logger = Logger.getLogger(ObjectManager.class);
    private static Storage storage = null;
    private static final String TOKEN_VARIABLE_NAME = "DATAONE_AUTH_TOKEN";
    private static final String TOKEN_FILE_PATH_PROP_NAME = "dataone.nodeToken.file";
    private static MultipartD1Node d1Node = null;
    private static Session session = null;

    private ObjectManager() {
    }

    public static ObjectManager getInstance() {
        return manager;
    }

    public InputStream getSystemMetadataStream(String id) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound, NoSuchAlgorithmException, IOException, MarshallingException {
        InputStream sysmetaInputStream;
        block3: {
            long start = System.currentTimeMillis();
            sysmetaInputStream = null;
            try {
                sysmetaInputStream = storage.retrieveSystemMetadata(id);
                long end = System.currentTimeMillis();
                logger.info((Object)("Finish getting the system metadata via the file system for the pid " + id + " and it took " + (end - start) + "milliseconds"));
            }
            catch (FileNotFoundException exception) {
                if (d1Node == null) break block3;
                SystemMetadata sysmeta = null;
                Identifier identifier = new Identifier();
                identifier.setValue(id);
                sysmeta = d1Node.getSystemMetadata(session, identifier);
                logger.debug((Object)("Finish getting the system metadata via the DataONE API call for the pid " + id));
                if (sysmeta != null) {
                    ByteArrayOutputStream systemMetadataOutputStream = new ByteArrayOutputStream();
                    TypeMarshaller.marshalTypeToOutputStream((Object)sysmeta, (OutputStream)systemMetadataOutputStream);
                    sysmetaInputStream = new ByteArrayInputStream(systemMetadataOutputStream.toByteArray());
                }
                long end = System.currentTimeMillis();
                logger.info((Object)("Finish getting the system metadata via DataONE API for the pid " + id + " and it took " + (end - start) + "milliseconds"));
            }
        }
        return sysmetaInputStream;
    }

    public org.dataone.service.types.v1.SystemMetadata getSystemMetadata(String id) throws InvalidToken, NotAuthorized, NoSuchAlgorithmException, NotImplemented, ServiceFailure, NotFound, InstantiationException, IllegalAccessException, IOException, MarshallingException {
        SystemMetadata sysmeta;
        block15: {
            sysmeta = null;
            try (InputStream input = this.getSystemMetadataStream(id);){
                if (input == null) break block15;
                try {
                    SystemMetadata sysmeta2;
                    sysmeta = sysmeta2 = (SystemMetadata)TypeMarshaller.unmarshalTypeFromStream(SystemMetadata.class, (InputStream)input);
                }
                catch (Exception e) {
                    try (InputStream input2 = this.getSystemMetadataStream(id);){
                        if (input2 != null) {
                            sysmeta = (org.dataone.service.types.v1.SystemMetadata)TypeMarshaller.unmarshalTypeFromStream(org.dataone.service.types.v1.SystemMetadata.class, (InputStream)input2);
                        }
                    }
                }
            }
        }
        return sysmeta;
    }

    public InputStream getObject(String pid) throws IllegalArgumentException, FileNotFoundException, NoSuchAlgorithmException, IOException {
        return storage.retrieveObject(pid);
    }

    public static void setD1Node(MultipartD1Node node) {
        d1Node = node;
    }

    private static void refreshD1Node() throws ServiceFailure {
        DataONEauthToken = System.getenv(TOKEN_VARIABLE_NAME);
        if (DataONEauthToken == null || DataONEauthToken.trim().equals("")) {
            String tokenFilePath = Settings.getConfiguration().getString(TOKEN_FILE_PATH_PROP_NAME);
            if (tokenFilePath != null && !tokenFilePath.trim().equals("")) {
                logger.info((Object)("ObjectManager.refreshD1Node - We can't get the token from the env variable so try to get the auth token from the file " + tokenFilePath));
                try {
                    DataONEauthToken = FileUtils.readFileToString((File)new File(tokenFilePath), (String)"UTF-8");
                }
                catch (IOException e) {
                    DataONEauthToken = null;
                    logger.warn((Object)("ObjectManager.refreshD1Node - can NOT get the authen token from the file " + tokenFilePath + " since " + e.getMessage()));
                }
                if (DataONEauthToken != null && !DataONEauthToken.trim().equals("")) {
                    logger.info((Object)("ObjectManager.refreshD1Node - Got the auth token from the file " + tokenFilePath));
                }
            }
        } else {
            logger.info((Object)"ObjectManager.refreshD1Node - Got the auth token from an env. variable");
        }
        if (DataONEauthToken == null || DataONEauthToken.trim().equals("")) {
            logger.warn((Object)"ObjectManager.refreshD1Node ------ Could NOT get an auth token from either an env. variable or the properties file. So it will act as the public user.");
        }
        session = ObjectManager.createSession(DataONEauthToken);
        logger.info((Object)("ObjectManager.refreshD1Node ------ going to create the d1node with url " + nodeBaseURL));
        try {
            d1Node = ObjectManager.getMultipartD1Node(session, nodeBaseURL);
        }
        catch (IOException | ClientSideException e) {
            logger.error((Object)("ObjectManager.refreshD1Node - couldn't create the d1node for the url " + nodeBaseURL + " since " + e.getMessage()));
            throw new ServiceFailure("0000", e.getMessage());
        }
    }

    private static Session createSession(String authToken) {
        Session session = null;
        if (authToken == null || authToken.trim().equals("")) {
            logger.info((Object)"ObjectManager.createSession - Creating the public session");
            session = new Session();
        } else {
            logger.info((Object)("ObjectManger.createSession - Creating authentication session from token: " + authToken.substring(0, 5) + "..."));
            session = new AuthTokenSession(authToken);
        }
        return session;
    }

    private static MultipartD1Node getMultipartD1Node(Session session, String serviceUrl) throws IOException, ClientSideException {
        HttpMultipartRestClient mrc = null;
        MultipartCNode d1Node = null;
        mrc = new HttpMultipartRestClient();
        Boolean isCN = ObjectManager.isCN(serviceUrl);
        if (isCN.booleanValue()) {
            logger.info((Object)("ObjectManager.getMultipartD1Node - creating cn MultipartMNode from the url " + serviceUrl));
            d1Node = new MultipartCNode((MultipartRestClient)mrc, serviceUrl, session);
        } else {
            logger.info((Object)("ObjectManager.getMultipartD1Node - creating mn MultipartMNode from the url " + serviceUrl));
            d1Node = new MultipartMNode((MultipartRestClient)mrc, serviceUrl, session);
        }
        return d1Node;
    }

    private static Boolean isCN(String nodeStr) {
        Boolean isCN = false;
        if (nodeStr.matches("^\\s*urn:node:.*")) {
            if (nodeStr.matches("^\\s*urn:node:CN.*$|^\\s*urn:node:cn.*$")) {
                isCN = true;
                logger.debug((Object)("ObjectManager.isCN - The nodeId is for a CN: " + nodeStr));
            } else {
                logger.debug((Object)("ObjectManager.isCN - The nodeId is not for a CN: " + nodeStr));
                isCN = false;
            }
        } else if (nodeStr.matches("^\\s*https*://cn.*?\\.dataone\\.org.*$|https*://cn.*?\\.test\\.dataone\\.org.*$")) {
            isCN = true;
            logger.debug((Object)("ObjectManager.isCN - The service URL is for a CN: " + nodeStr));
        } else {
            logger.debug((Object)("ObjectManager.isCN - The service URL is not for a CN: " + nodeStr));
            isCN = false;
        }
        return isCN;
    }

    static {
        try {
            ObjectManager.refreshD1Node();
        }
        catch (ServiceFailure e) {
            logger.warn((Object)("Metacat cannot initialize the d1Node since " + e.getMessage()));
        }
        storage = Storage.getInstance();
        manager = new ObjectManager();
    }
}

