/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.osti_elink.v2.response;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.ucsb.nceas.osti_elink.OSTIElinkException;

public class JsonResponseHandler {
    public static String getPathValue(String json, String path) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode arrayNode = mapper.readTree(json);
        if (arrayNode != null && arrayNode.isArray()) {
            for (JsonNode node : arrayNode) {
                JsonNode element = node.get(path);
                if (element == null || element.asText() == null) continue;
                return element.asText();
            }
        }
        return null;
    }

    public static ObjectNode getFirstNodeInArray(String json) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode arrayNode = mapper.readTree(json);
        if (arrayNode != null && arrayNode.isArray()) {
            return (ObjectNode)arrayNode.get(0);
        }
        return null;
    }

    public static JsonNode isResponseWithError(String response) throws OSTIElinkException {
        JsonNode node;
        if (response == null || response.trim().equals("")) {
            throw new OSTIElinkException("The response for the request is blank");
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            node = mapper.readTree(response);
            if (node.get("errors") != null) {
                throw new OSTIElinkException("The request failed since " + response);
            }
        }
        catch (JsonProcessingException e) {
            throw new OSTIElinkException("The response for the request is not a valid json string: " + response);
        }
        return node;
    }

    public static boolean isEmptyArray(JsonNode node) {
        return node != null && node.isArray() && node.isEmpty();
    }
}

